using System.IO;
using UnityEditor;
using UnityEngine;
using static Magify.PackageInfo;

namespace Magify
{
    public static class MagifyMenuItems
    {
        public const string FileSystemName = RootMenuItem + "Package Persistent Folder/";

        [MenuItem(FileSystemName + "Reveal in Explorer")]
        public static void OpenPrefsFolder()
        {
            var cacheFolder = PersistentPath;
            if (Directory.Exists(cacheFolder))
            {
                EditorUtility.RevealInFinder(cacheFolder);
            }
            else
            {
                EditorUtility.RevealInFinder(Application.persistentDataPath);
            }
        }

        [MenuItem(FileSystemName + "Delete all data")]
        public static void ClearPrefsFolder()
        {
            var cacheFolder = PersistentPath;
            if (Directory.Exists(cacheFolder))
            {
                Directory.Delete(cacheFolder, true);
            }
        }
    }
}