﻿using System;

namespace Magify
{
    public class SubscriptionInfo
    {
        public readonly string ProductId;
        public readonly bool IsFreeTrial;
        public readonly DateTime ExpireDate;
        public readonly SubscriptionPeriodModel PeriodModel;

        public SubscriptionInfo(string productId, bool isFreeTrial, DateTime expireDate, SubscriptionPeriodModel periodModel)
        {
            ProductId = productId;
            IsFreeTrial = isFreeTrial;
            ExpireDate = expireDate;
            PeriodModel = periodModel;
        }

        public bool IsExpired(DateTime utcNow)
        {
            return ExpireDate - utcNow < TimeSpan.Zero;
        }
    }
}