using System;
using System.Collections.Generic;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify
{
    public class PopupArgs
    {
        public ILocalizer Localizer { get; internal set; }
        public float CloseButtonDelay { get; init; }

        [CanBeNull]
        public IReadOnlyDictionary<string, object> Attributes { get; }

        public PopupArgs([CanBeNull] IReadOnlyDictionary<string, object> attributes = null)
        {
            Attributes = attributes;
        }
    }

    public interface IPopupBase<in TArgs> : IDisposable
        where TArgs : PopupArgs
    {
        event Action OnHideRequested;

        UniTask ShowAsync(TArgs arguments, CancellationToken cancellationToken);
        UniTask HideAsync(CancellationToken cancellationToken);
    }

    public interface IPopup<in TArgs> : IPopupBase<TArgs>
        where TArgs : PopupArgs
    {
        event Action OnClicked;
    }

    public interface IPopupWithProducts<in TArgs> : IPopupBase<TArgs>
        where TArgs : PopupArgs
    {
        event Action<ProductDef> OnClicked;
        bool CloseAfterObtain => true;
        void UpdateProducts(IReadOnlyList<ProductDef> products);
    }
}