using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    public enum NetworkState
    {
        Reachable,
        NotReachable
    }

    public interface INetworkStatusProvider
    {
        [NotNull]
        public IReactiveProperty<NetworkState> Reachability { get; }
        public bool IsNetworkReachable => Reachability.Value == NetworkState.Reachable;
    }
}