﻿using System;

namespace Magify
{
    public interface IAdsMediator : IMinimalAdsMediator
    {
        bool IsInitialized { get; }

        #region Banner

        event Action<string> OnBannerLoadFailed;
        event Action<IAdsImpression> OnBannerClicked;
        bool IsBannerVisible { get; }
        void ShowBanner();
        void HideBanner();

        #endregion

        #region Reward

        event Action OnRewardLoaded;
        event Action<string> OnRewardLoadFailed;
        event Action<string> OnRewardDisplayFailed;
        event Action OnRewardReceived;
        event Action<IAdsImpression> OnRewardClicked;
        event Action<IAdsImpression> OnRewardHidden;
        bool IsRewardedVideoReady { get; }
        void LoadRewardVideo();
        void ShowRewardVideo(string placement);

        #endregion

        #region Interstitial

        event Action OnInterLoaded;
        event Action<string> OnInterLoadFailed;
        event Action<string> OnInterDisplayFailed;
        event Action<IAdsImpression> OnInterClicked;
        event Action<IAdsImpression> OnInterHidden;
        bool IsInterVideoReady { get; }
        void LoadInterVideo();
        void ShowInterVideo(string placement);

        #endregion
    }
}