﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public readonly struct ProductObtainResult
    {
        public bool IsBought => FailReason == null;

        [CanBeNull]
        public readonly ProductObtainFailReason? FailReason;

        [NotNull]
        public readonly ProductDef Product;

        [CanBeNull]
        public readonly ICampaign Campaign;

        [CanBeNull]
        public readonly string Spot;

        [CanBeNull]
        public readonly PurchaseInfo PurchaseInfo;

        [NotNull]
        public string Id => Product.Id;

        [NotNull]
        public IEnumerable<PayoutDef> Bonuses => Product.Payout;

        [CanBeNull]
        public CampaignType? CampaignType => Campaign?.Type;

        [CanBeNull]
        public string CampaignName => Campaign?.Name ?? string.Empty;

        [CanBeNull]
        public IReadOnlyDictionary<string, object> Context => Product.Context;

        [CanBeNull, Obsolete("Use " + nameof(Spot) + " instead")]
        public string Placement => Spot;

        public ProductObtainResult(ProductDef product, PurchaseInfo purchaseInfo)
            : this(product, null, null, null, purchaseInfo)
        {
        }

        public ProductObtainResult(ProductDef product, ProductObtainFailReason failReason)
            : this(product, null, null, failReason, null)
        {
        }

        public ProductObtainResult(ProductDef product, CampaignRequest request, ProductObtainFailReason failReason)
            : this(product, request.Event, request.Campaign, failReason, null)
        {
        }

        public ProductObtainResult(ProductDef product, CampaignRequest request, PurchaseInfo purchaseInfo)
            : this(product, request.Event, request.Campaign, null, purchaseInfo)
        {
        }

        public ProductObtainResult(ProductDef product, CampaignRequest request)
            : this(product, request.Event, request.Campaign, null, null)
        {
        }

        public ProductObtainResult(ProductDef product, string spot, ICampaign campaign, ProductObtainFailReason? failReason, PurchaseInfo purchaseInfo = null)
        {
            FailReason = failReason;
            Product = product;
            Spot = spot;
            Campaign = campaign;
            PurchaseInfo = purchaseInfo;
        }
    }
}