using System.IO;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify
{
    public class AppStateFromFileProvider : IAppStateProvider
    {
        [NotNull]
        private readonly string _filePath;

        public AppStateFromFileProvider([NotNull] string filePath)
        {
            _filePath = filePath;
        }

        public UniTask<string> PrepareState(CancellationToken cancellationToken)
        {
            if (File.Exists(_filePath))
            {
                return UniTask.FromResult(File.ReadAllText(_filePath));
            }
            return UniTask.FromResult(default(string));
        }

        public async UniTask HandleState([NotNull] string state, [CanBeNull] int? weight, CancellationToken cancellationToken)
        {
            var dir = Path.GetDirectoryName(_filePath)!;
            if (!Directory.Exists(dir))
            {
                Directory.CreateDirectory(dir);
            }
            var task = File.WriteAllTextAsync(_filePath, state, cancellationToken);
            if (task != null)
            {
                await task;
            }
        }
    }
}