﻿using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    [CreateAssetMenu(menuName = "Magify/Settings", fileName = nameof(MagifySettings))]
    public class MagifySettings : ScriptableObject, IPresenterSettings
    {
        public const string NoAds = "no_ads";
        public const string CloseButtonOverridesAttribute = "close_button_overrides";
        public const string LimitedTimeOfferAlertEnabledAttribute = "alert_enabled";
        public const string InterNotifierCloseButton = "inter_notifier_close_button";

        public const string ForceSyncOnFocusAfterFeature = "force_sync_on_focus_after";
        public const string ScreenLoadTimeoutFeature = "screen_load_timeout";
        public const string VisibleCloseInterButtonFeature = "visible_close_inter_button";
        public const string RewardLoadTimeoutFeature = "rv_timeout";
        public const string StoredAppFeaturesLoadingTimeoutSecondsFeature = "stored_app_features_timeout";
        public const string ProductFetchTimeoutFeature = "in_app_fetch_timeout";
        public const string PurchasesRestoreTimeoutFeature = "in_app_restore_timeout";
        public const string RateReviewCloseButtonDelayFeature = "rr_close_button_delay";

        [field: Header("General Settings (Required)")]

        #region General settings

        [field: SerializeField, Tooltip("Android: Application name. Can't be changed after initialization")]
        public string NameGP { get; set; } = "game gps";

        [field: SerializeField, Tooltip("iOS: Application name. Can't be changed after initialization")]
        public string NameIOS { get; set; } = "game ios";

        [field: SerializeField, Tooltip("Android: Path in StreamingAssets to default config"), MagifySettingsOptional()]
        public string ConfigGP { get; set; } = "Magify-GP.json";

        [field: SerializeField, Tooltip("iOS: Path in StreamingAssets to default config"), MagifySettingsOptional()]
        public string ConfigIOS { get; set; } = "Magify-IOS.json";

        #endregion

#if MAX_ADS_MEDIATOR

        [field: Header("Applovin Settings (Required)")]

        #region Applovin Settings

        [field: SerializeField]
        public string SdkKey { get; set; }

        [field: SerializeField]
        public string BannerAdUnitIdGP { get; set; }

        [field: SerializeField]
        public string InterAdUnitIdGP { get; set; }

        [field: SerializeField]
        public string RewardAdUnitIdGP { get; set; }

        [field: SerializeField]
        public string BannerAdUnitIdIOS { get; set; }

        [field: SerializeField]
        public string InterAdUnitIdIOS { get; set; }

        [field: SerializeField]
        public string RewardAdUnitIdIOS { get; set; }

        #endregion

#endif

#if LEVELPLAY_MEDIATOR

        [field: Header("LevelPlay Settings (Required)")]

        #region IronSource LevelPlay Settings

        [field: SerializeField]
        public string ApkKeyGP { get; set; }

        [field: SerializeField]
        public string ApkKeyIOS { get; set; }

        #endregion

#endif

        // [field: Header("Banner Campaign (Required)")]
        //
        // #region Banner Campaign
        //
        // [field: SerializeField]
        // public Color BannerBackgroundColor { get; set; } = Color.white;
        //
        // [field: SerializeField]
        // public Color BannerCloseColor { get; set; } = Color.black;
        //
        // #endregion

        #region Rate And Review Campaign

        [field: SerializeField, MagifySettingsOptional("Rate And Review Campaign (Required)")]
        public string RateUsLinkAndroid { get; set; } = "market://details?id=farm.parking.game";

        [field: SerializeField, MagifySettingsOptional()]
        public string RateUsLinkIOS { get; set; } = "https://apps.apple.com/us/app/appname/1629034559?action=write-review";

        #endregion

        #region Embedded Canvas

        [field: SerializeField, Tooltip("Render Mode for embedded canvas. If you want to use RenderMode.ScreenSpaceCamera, don't forget to setup camera in MagifyService.Presenter.Canvas.worldCamera after initialization"), MagifySettingsOptional("Embedded Canvas (Optional)")]
        public RenderMode RenderMode { get; set; } = RenderMode.ScreenSpaceOverlay;

        [field: SerializeField, Tooltip("Sorting Order for canvas used by package"), MagifySettingsOptional()]
        public int SortingOrder { get; set; } = 900;

        [field: SerializeField, Tooltip("Default resolution for embedded canvas"), MagifySettingsOptional()]
        public Vector2Int ReferenceResolution { get; set; } = new Vector2Int(1080, 1920);

        [field: SerializeField, Tooltip("CanvasScaler: Default scale mode for embedded canvas"), MagifySettingsOptional()]
        public CanvasScaler.ScaleMode UiScaleMode { get; set; } = CanvasScaler.ScaleMode.ScaleWithScreenSize;

        [field: SerializeField, Tooltip("CanvasScaler: Default MatchWidthOrHeight for embedded canvas"), MagifySettingsOptional(), Range(0, 1)]
        public float MatchWidthOrHeight { get; set; } = 0f;

        [field: SerializeField, Tooltip("CanvasScaler: Default ReferencePixelsPerUnit for embedded canvas"), MagifySettingsOptional()]
        public float ReferencePixelsPerUnit { get; set; } = 100;

        #endregion

        #region Default Features

        [field: Header("Default Features (Optional)")]

        [field: SerializeField]
        public NumberRemoteProperty RewardLoadTimeout { get; set; } = new NumberRemoteProperty(RewardLoadTimeoutFeature, 5);

        [field: SerializeField, MagifySettingsOptional()]
        public NumberRemoteProperty ForceSyncOnFocusAfter { get; set; } = new NumberRemoteProperty(ForceSyncOnFocusAfterFeature, 60);

        [field: SerializeField, MagifySettingsOptional()]
        public NumberRemoteProperty ScreenLoadTimeout { get; set; } = new NumberRemoteProperty(ScreenLoadTimeoutFeature, 10);

        [field: SerializeField, MagifySettingsOptional()]
        public NumberRemoteProperty ProductFetchTimeout { get; set; } = new NumberRemoteProperty(ProductFetchTimeoutFeature, 10);

        [field: SerializeField, MagifySettingsOptional()]
        public NumberRemoteProperty RateReviewCloseButtonDelay { get; set; } = new NumberRemoteProperty(RateReviewCloseButtonDelayFeature, 0);

        [field: SerializeField]
        public NumberRemoteProperty StoredAppFeaturesLoadingTimeoutSeconds { get; set; } = new NumberRemoteProperty(StoredAppFeaturesLoadingTimeoutSecondsFeature, 30);

        // [field: SerializeField, HideIf(nameof(_useBaseVersion))]
        // public NumberRemoteProperty PurchasesRestoreTimeout { get; set; } = new NumberRemoteProperty(PurchasesRestoreTimeoutFeature, 2.5f);

        // [field: SerializeField, HideIf(nameof(_useBaseVersion))]
        // public BoolRemoteProperty VisibleCloseInterButton { get; set; } = new BoolRemoteProperty(VisibleCloseInterButtonFeature, true);

        #endregion

        #region Embedded Events

        [field: SerializeField, MagifySettingsOptional("Embedded Events (Optional)")]
        public string ConsentGivenEvent { get; set; } = "consent_given";

        [field: SerializeField, MagifySettingsOptional()]
        public string SessionStartedEvent { get; set; } = "session_start";

        [field: SerializeField, MagifySettingsOptional()]
        public string HotSessionStartedEvent { get; set; } = "hot_session_start";

        [field: SerializeField, MagifySettingsOptional()]
        public string BannerDefaultEvent { get; set; } = "banner_default";

        [field: SerializeField, MagifySettingsOptional()]
        public string InterstitialFailedEvent { get; set; } = "interstitial_failed";

        [field: SerializeField, MagifySettingsOptional()]
        public string InterstitialShowedEvent { get; set; } = "interstitial_showed";

        [field: SerializeField, MagifySettingsOptional()]
        public string RewardedVideoFailedEvent { get; set; } = "rewarded_video_failed";

        [field: SerializeField, MagifySettingsOptional()]
        public string RewardedVideoShowedEvent { get; set; } = "rewarded_video_showed";

        [field: SerializeField, MagifySettingsOptional()]
        public string CampaignClosedEvent { get; set; } = "campaign_closed";

        [field: SerializeField, MagifySettingsOptional()]
        public string OfferFinishedEvent { get; set; } = "offer_finished";

        #endregion

        #region Embedded Params

        [field: SerializeField, MagifySettingsOptional(header: "Embedded Params (Optional)")]
        public string SourceParam { get; set; } = "source";

        [field: SerializeField, MagifySettingsOptional()]
        public string AwayTimeParam { get; set; } = "away_time";

        [field: SerializeField, MagifySettingsOptional()]
        public string CampaignParam { get; set; } = "campaign";

        [field: SerializeField, MagifySettingsOptional()]
        public string CampaignTypeParam { get; set; } = "campaign_type";

        #endregion
    }
}