﻿namespace Magify
{
    public struct SubscriptionPeriodModel
    {
        public int Years;
        public int Months;
        public int Weeks;
        public int Days;

        public bool IsYearly => Years == 1 && Months == 0 && Weeks == 0 && Days == 0;
        public bool IsMonthly => Years == 0 && Months == 1 && Weeks == 0 && Days == 0;
        public bool IsWeekly => Years == 0 && Months == 0 && Weeks == 1 && Days == 0;
        public bool IsDaily => Years == 0 && Months == 0 && Weeks == 0 && Days == 1;

        public SubscriptionPeriodModel(int years, int months, int weeks, int days)
        {
            Years = years;
            Months = months;
            Weeks = weeks;
            Days = days;
        }

        public SubscriptionPeriodModel(string isoFormat) : this(0, 0, 0, 0)
        {
            var value = string.Empty;

            for (var i = 1; i < isoFormat.Length; i++)
            {
                var symbol = isoFormat[i];

                if (symbol.Equals('T'))
                {
                    return;
                }

                if (char.IsDigit(symbol))
                {
                    value += symbol;
                    continue;
                }

                switch (symbol)
                {
                    case 'Y':
                        Years = int.Parse(value);
                        break;
                    case 'M':
                        Months = int.Parse(value);
                        break;
                    case 'W':
                        Weeks = int.Parse(value);
                        break;
                    case 'D':
                        Days = int.Parse(value);
                        break;
                }
                value = string.Empty;
            }
        }

        public SubscriptionPeriodModel(SubscriptionPeriodType subscriptionPeriodType, int numberUnits = 1) : this(0, 0, 0, 0)
        {
            switch (subscriptionPeriodType)
            {
                case SubscriptionPeriodType.Day:
                    if (numberUnits % 7 == 0)
                    {
                        Weeks = numberUnits / 7;
                        return;
                    }
                    
                    Days = numberUnits;
                    break;
                case SubscriptionPeriodType.Week:
                    Weeks = numberUnits;
                    break;
                case SubscriptionPeriodType.Month:
                    Months = numberUnits;
                    break;
                case SubscriptionPeriodType.Year:
                    Years = numberUnits;
                    break;
                default:
                    throw new($"{subscriptionPeriodType} is incorrect value for formatting");
            }
        }

        public SubscriptionPeriodModel ToWeeksToDays()
        {
            Days += Weeks * 7;
            Weeks = 0;
            
            return this;
        }
    }
}