using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal class AghanimStorePrefs : ICancelable
    {
        [NotNull]
        private const string KeyProcessedOrders = "processed_orders";
        [NotNull]
        private const string KeyProcessedPurchasedProducts = "processed_purchased_products";
        [NotNull]
        private readonly BinaryStorage _storage;

        [NotNull]
        public ISet<string> ProcessedOrders { get; }
        [NotNull]
        public IDictionary<string, int> ProcessedPurchasedProducts { get; }

        public bool IsDisposed => _storage.Disposed;

        public AghanimStorePrefs([NotNull] string storagePath)
        {
            _storage = BinaryStorage.Construct(storagePath)
                .AddPrimitiveTypes()
                .SupportSetsOf<string>()
                .SupportDictionariesOf<string, int>()
                .Build();

            ProcessedOrders = _storage.GetSet<string>(KeyProcessedOrders);
            ProcessedPurchasedProducts = _storage.GetDictionary<string, int>(KeyProcessedPurchasedProducts);
        }

        public void Dispose()
        {
            _storage.Dispose();
        }
    }
}