using System;
using Magify.Rx;
using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    public class Popup : Popup<PopupArgs>
    {
    }

    public class Popup<TArgs> : PopupBase<TArgs>, IPopup<TArgs>
        where TArgs : PopupArgs
    {
        public event Action OnClicked;

        [SerializeField]
        private Button[] _popupButtons = Array.Empty<Button>();

        protected override void PrepareForShow(TArgs arguments, CompositeDisposable disposables)
        {
            base.PrepareForShow(arguments, disposables);

            foreach (var button in _popupButtons)
            {
                button
                    .SubscribeOnClick(ButtonClickedHandler)
                    .AddTo(disposables);
            }
        }

        private void ButtonClickedHandler()
        {
            OnClicked?.Invoke();
        }
    }
}