using System.Collections.Generic;
using Magify.Rx;
using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    public class ImagePopup : Popup<ImagePopup.Args>
    {
        public class Args : PopupArgs
        {
            public ImageCreative Creative { get; }
            public Texture Texture { get; }

            public Args(ImageCreative creative, Texture texture)
                : base(creative.Attributes)
            {
                Creative = creative;
                Texture = texture;
            }
        }

        [SerializeField]
        private RawImage _image;
        [SerializeField]
        private AspectRatioFitter _ratio;
        [SerializeField]
        private List<Graphic> _coloredParts = new List<Graphic>();

        protected override void PrepareForShow(Args arguments, CompositeDisposable disposables)
        {
            base.PrepareForShow(arguments, disposables);
            _image.texture = arguments.Texture;
            _ratio.aspectRatio = (float)arguments.Texture.width / arguments.Texture.height;
            _coloredParts?.ForEach(c => c.color = arguments.Creative.Background.Color);
        }
    }
}