using Cysharp.Threading.Tasks;
using UnityEngine;

namespace Magify
{
    public class LimitedTimeOffer : LimitedTimeOfferBase
    {
        public void CompleteOffer()
        {
            if (Offer != null)
            {
                MagifyService.Instance.Offers.CompleteActiveLto(Offer.CampaignName);
            }
        }

        protected override void OnButtonClick()
        {
            RequestCampaign().Forget();
        }

        protected async UniTaskVoid RequestCampaign()
        {
            Debug.Log($"Request campaign from LTO for spot: {Offer.Spot}");
            var result = await MagifyService.Instance.RequestCampaignAsync(Offer.Spot);
            Debug.Log($"Campaign for spot: {Offer.Spot} finish with result: {result}");
        }
    }
}