﻿using System.Threading;
using Cysharp.Threading.Tasks;

namespace Magify
{
    public interface IProductObtainer
    {
        public bool ObtainUnderSpin => false;
        public bool CanObtainProduct(ProductDef product);
        public bool NeedPrepareProduct(ProductDef product) => false;
        public UniTask<ProductPrepareResult> PrepareProductAsync(ProductDef product, CancellationToken cancellationToken) => UniTask.FromResult(ProductPrepareResult.Success());
        public UniTask<ProductObtainResult> ObtainProductAsync(ProductDef product, CampaignRequest request, CancellationToken cancellationToken);
    }

    public abstract class ProductObtainer<T> : IProductObtainer
        where T : ProductDef
    {
        public virtual bool CanObtainProduct(ProductDef product)
        {
            return product is T;
        }

        public UniTask<ProductObtainResult> ObtainProductAsync(ProductDef product, CampaignRequest request, CancellationToken cancellationToken)
        {
            return ObtainProductAsync((T)product, request, cancellationToken);
        }

        private protected abstract UniTask<ProductObtainResult> ObtainProductAsync(T product, CampaignRequest request, CancellationToken cancellationToken);
    }
}