﻿using System;

namespace Magify
{
    /// <summary>
    /// You should implement this interface in your mediator class if you want to send info about showed ads to the Magify SDK. <br/>
    /// </summary>
    public interface IMinimalAdsMediator
    {
        #region Banner

        /// <summary>
        /// Will be specific for different mediators. Must be invoked when the mediator sending revenue-data.
        /// </summary>
        event Action<IAdsImpression> OnBannerLoaded;

        #endregion

        #region Reward

        /// <summary>
        /// Will be specific for different mediators. Must be invoked when the mediator sending revenue-data.
        /// </summary>
        event Action<IAdsImpression> OnRewardShown;

        #endregion

        #region Interstitial

        /// <summary>
        /// Will be specific for different mediators. Must be invoked when the mediator sending revenue-data.
        /// </summary>
        event Action<IAdsImpression> OnInterShown;

        #endregion
    }
}