using JetBrains.Annotations;

namespace Magify
{
    public readonly struct ProductPrepareResult
    {
        public bool Succeed => FailReason != null;

        [CanBeNull]
        public readonly ProductObtainFailReason? FailReason;
        [CanBeNull]
        public readonly string FailMessage;

        public ProductPrepareResult(ProductObtainFailReason failReason, string failMessage = null)
        {
            FailReason = failReason;
            FailMessage = failMessage;
        }

        public static ProductPrepareResult Success() => new();

        public static ProductPrepareResult FromAdLoadResult(AdLoadResult loadResult)
        {
            return loadResult.State switch
            {
                AdLoadState.Loaded => Success(),
                AdLoadState.Timeout => Fail(ProductObtainFailReason.Timeout, loadResult.Error),
                AdLoadState.NoInternet => Fail(ProductObtainFailReason.NoInternet, loadResult.Error),
                AdLoadState.MediatorError => Fail(ProductObtainFailReason.MediatorError, loadResult.Error),
                _ => Fail(loadResult.Error)
            };
        }

        public static ProductPrepareResult Fail(ProductObtainFailReason failReason, string failMessage = null) => new(failReason, failMessage);
        public static ProductPrepareResult Fail(string failMessage) => new(ProductObtainFailReason.Unknown, failMessage);
    }
}