﻿using System.Threading;
using Cysharp.Threading.Tasks;
using UnityEngine;

namespace Magify
{
    internal class InfoProductObtainer : ProductObtainer<InfoProduct>
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        private protected override UniTask<ProductObtainResult> ObtainProductAsync(InfoProduct product, CampaignRequest request, CancellationToken cancellationToken)
        {
            _logger.Log($"Obtaining {product.GetType().Name} ({product.Id}): info products don't need any specific logic to obtain.");
            return UniTask.FromResult(new ProductObtainResult(product, request));
        }
    }
}