using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Rx;
using static Magify.MagifyManager;

namespace Magify
{
    public class AnalyticsService : BaseAnalyticsService
    {
        private readonly Subject<CustomEvent> _onBeforeSendEvent = new();
        private readonly Subject<CustomEvent> _onAfterSendEvent = new();

        public IObservable<CustomEvent> OnBeforeSendEvent => _onBeforeSendEvent;
        public IObservable<CustomEvent> OnAfterSendEvent => _onAfterSendEvent;

        public void TrackEvent(string name, Dictionary<string, object> @params)
        {
            var @event = new CustomEvent(name, @params);
            TrackEvent(@event);
        }

        public void TrackEvent(CustomEvent @event)
        {
            _onBeforeSendEvent.OnNext(@event);
            TrackCustomEvent(@event.Name, @event.Params);
            _onAfterSendEvent.OnNext(@event);
        }

        public void SetGameMode(string mode)
        {
            MagifyManager.GameState.SetGameMode(mode);
        }

        public void SetGameLevel(int level)
        {
            MagifyManager.GameState.SetGameLevel(level);
        }

        public void SetGameMaxLevel(int level)
        {
            MagifyManager.GameState.SetGameMaxLevel(level);
        }

        public void TrackIncomeTransaction([NotNull] string source, [NotNull] List<BonusInfo> bonuses, [CanBeNull] ProductInfo product = null)
        {
            MagifyManager.TrackIncomeTransaction(source, bonuses, product);
        }

        public void TrackIncomeTransaction([NotNull] string source, [NotNull] List<BonusInfo> bonuses, ProductObtainResult result)
        {
            TrackIncomeTransaction(source, bonuses, result.Id, result.PurchaseInfo);
        }

        public void TrackIncomeTransaction([NotNull] string source, [NotNull] List<BonusInfo> bonuses, [CanBeNull] string productId = null, [CanBeNull] PurchaseInfo purchaseInfo = null)
        {
            var internalInfo = productId == null && purchaseInfo == null
                ? null
                : new ProductInfo(productId, purchaseInfo?.Price, purchaseInfo?.Currency, purchaseInfo?.Store);

            MagifyManager.TrackIncomeTransaction(source, bonuses, internalInfo);
        }

        public void TrackExpenseTransaction(List<BonusInfo> bonuses)
        {
            MagifyManager.TrackExpenseTransaction(bonuses);
        }

        public void TrackCorrectionTransaction(List<BonusInfo> bonuses)
        {
            MagifyManager.TrackCorrectionTransaction(bonuses);
        }
    }
}