namespace Magify
{
    public class AdLoadResult
    {
        public static AdLoadResult Ready() => new() { State = AdLoadState.Loaded };
        public static AdLoadResult NotReady() => new() { State = AdLoadState.NotReady, Error = "Ads mediator is not ready yet" };
        public static AdLoadResult NoInternet() => new() { State = AdLoadState.NoInternet, Error = "No internet" };
        public static AdLoadResult Timeout() => new() { State = AdLoadState.Timeout, Error = "Timeout" };
        public static AdLoadResult MediatorError(string mediatorMessage) => new() { State = AdLoadState.MediatorError, Error = mediatorMessage };
        public static AdLoadResult Unexpected(string message) => new() { State = AdLoadState.Unexpected, Error = message };

        public AdLoadState State;
        public string Error;

        public override string ToString()
        {
            var toString = $"State={State}";
            if (!string.IsNullOrEmpty(Error))
            {
                toString += $"; Error={Error}";
            }
            return toString;
        }
    }

    public enum AdLoadState
    {
        Loaded,
        NoInternet,
        NotReady,
        Timeout,
        MediatorError,
        Unexpected,
    }
}