﻿using System;
using UnityEngine;

namespace Magify.DependenciesInstaller
{
    [Serializable]
    internal class ScopedRegistry
    {
        [field: SerializeField]
        public string RegistryName { get; private set; }

        [field: SerializeField]
        public string URL { get; private set; }

        [field: SerializeField]
        public string[] Scopes { get; private set; }

        public ScopedRegistry(string registryName, string url, string[] scopes)
        {
            RegistryName = registryName;
            URL = url;
            Scopes = scopes;
        }
    }
}