using System;
using System.Threading.Tasks;
using Cysharp.Threading.Tasks;
using FluentAssertions;
using Magify.Rx;
using NUnit.Framework;
using UnityEngine;

namespace Magify.Tests
{
    internal class TimerTests
    {
        [Test]
        [TestCase(10)]
        [TestCase(30)]
        [TestCase(50)]
        [Timeout(1000)]
        public async Task WhenTimerCreated_ThenCallbackReceived(int delayMs)
        {
            // Arrange
            var cancellationToken = Utils.GetCancellationToken();
            var received = 0;
            var timer = Observable.Timer(TimeSpan.FromMilliseconds(delayMs));
            using var _ = timer.Subscribe(_ => received++);

            // Act
            await UniTask.Delay(Mathf.RoundToInt(delayMs * 1.5f), cancellationToken: cancellationToken);
            await UniTask.SwitchToMainThread(cancellationToken);

            // Assert
            received.Should()!.Be(1);
        }

        // [Test]
        // [TestCase(10, 5)]
        // [TestCase(30, 3)]
        // [TestCase(50, 2)]
        // [Timeout(1000)]
        public async Task WhenIntervalCreated_ThenCallbacksReceived(int delayMs, int waitRepeats)
        {
            // Arrange
            var cancellationToken = Utils.GetCancellationToken();
            var received = 0;
            var timer = Observable.Interval(TimeSpan.FromMilliseconds(delayMs));
            using var _ = timer.Subscribe(_ => received++);

            // Act
            await UniTask.Delay(delayMs * waitRepeats + delayMs / 2, cancellationToken: cancellationToken);
            await UniTask.SwitchToMainThread(cancellationToken);

            // Assert
            received.Should()!.Be(waitRepeats);
        }
    }
}