﻿using System;
using FluentAssertions;
using JetBrains.Annotations;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class GuidUtilityTests
    {
        [Test]
        [TestCase("6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.com", "21f7f8de-8051-5b89-8680-0195ef798b6a")]
        [TestCase("28968169-fed8-467f-acc6-90571bc74294", "helloWorld", "773d2d6f-5485-577c-8a5b-1abc49ebb5cc")]
        public void WhenCreateGuid_ThenItsAsExpected([NotNull] string namespaceId, [NotNull] string name, [NotNull] string expected)
        {
            //Arrange
            //Act
            var guid = GuidUtility.Create(new Guid(namespaceId), name);

            //Assert
            guid.Should()!.Be(expected);
        }

        [Test]
        [TestCase("6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.com",
            "6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.com")]
        public void WhenCreate2GuidWithSameNamespaceAndName_ThenTheyTheSame(
            [NotNull] string namespaceId1, [NotNull] string name1,
            [NotNull] string namespaceId2, [NotNull] string name2)
        {
            //Arrange
            //Act
            var guid1 = GuidUtility.Create(new Guid(namespaceId1), name1);
            var guid2 = GuidUtility.Create(new Guid(namespaceId2), name2);

            //Assert
            guid1.Should()!.Be(guid2);
        }

        [Test]
        [TestCase("6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.by",
            "6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.kz")]
        public void WhenCreate2GuidWithSameNamespaceButDifferentName_ThenTheyNotTheSame(
            [NotNull] string namespaceId1, [NotNull] string name1,
            [NotNull] string namespaceId2, [NotNull] string name2)
        {
            //Arrange
            //Act
            var guid1 = GuidUtility.Create(new Guid(namespaceId1), name1);
            var guid2 = GuidUtility.Create(new Guid(namespaceId2), name2);

            //Assert
            guid1.Should()!.NotBe(guid2);
        }

        [Test]
        [TestCase("6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.widgets.ua",
            "28968169-fed8-467f-acc6-90571bc74294", "www.widgets.ua")]
        public void WhenCreate2GuidWithSameNameButDifferentNamespace_ThenTheyNotTheSame(
            [NotNull] string namespaceId1, [NotNull] string name1,
            [NotNull] string namespaceId2, [NotNull] string name2)
        {
            //Arrange
            //Act
            var guid1 = GuidUtility.Create(new Guid(namespaceId1), name1);
            var guid2 = GuidUtility.Create(new Guid(namespaceId2), name2);

            //Assert
            guid1.Should()!.NotBe(guid2);
        }
    }
}