﻿using System.Text;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    public class EmailValidatorTests
    {
        [Test]
        public void EmptyEmail()
        {
            var isValid = EmailValidator.IsValidEmail("", out var error);
            isValid.Should().BeFalse();
            error.Should().Be(EmailValidator.EmailValidationError.Empty);
        }

        [Test]
        public void EmailTooLong()
        {
            var emailBuilder = new StringBuilder();
            emailBuilder.Append('a', 1000);
            emailBuilder.Append("@mail.com");
            var isValid = EmailValidator.IsValidEmail(emailBuilder.ToString(), out var error);
            isValid.Should().BeFalse();
            error.Should().Be(EmailValidator.EmailValidationError.TooLong);
        }

        [Test]
        public void NoAtSignInEmail()
        {
            var emailBuilder = new StringBuilder();
            emailBuilder.Append('a', 10);
            emailBuilder.Append("mail.com");
            var isValid = EmailValidator.IsValidEmail(emailBuilder.ToString(), out var error);
            isValid.Should().BeFalse();
            error.Should().Be(EmailValidator.EmailValidationError.NoAtSign);
        }

        [Test]
        public void DuplicatedAtSign()
        {
            var emailBuilder = new StringBuilder();
            emailBuilder.Append('a', 50);
            emailBuilder.Append("@mail@nomail.com");
            var isValid = EmailValidator.IsValidEmail(emailBuilder.ToString(), out var error);
            isValid.Should().BeFalse();
            error.Should().Be(EmailValidator.EmailValidationError.DuplicatedAtSign);
        }
    }
}