namespace Magify.Tests
{
    /*
    [Ignore("")]
    public class NetworkTests
    {
        private readonly NetworkClient _networkClient = new();

        private PlatformAPI _platformAPI;
        private CancellationTokenSource _timeoutCts;

        private static EndpointUrl ProductionUrl => EndpointUrl.Production;
        private static EndpointUrl StagingUrl => EndpointUrl.Staging;
        private IAuthorizationConfigBuilder AuthConfig => NetworkTestEnvironment.AuthConfig;

        [SetUp]
        public void Setup()
        {
            EditorModeTestsEnvironment.Clear();
            _platformAPI = new PlatformDefault();
            _timeoutCts = new CancellationTokenSource();
        }

        [TearDown]
        public void Cleanup()
        {
            _platformAPI.Dispose();
            _timeoutCts.Cancel();
            _timeoutCts.Dispose();
            EditorModeTestsEnvironment.Clear();
        }

        [Test]
        public async Task GetAuthorizationTokenAsync_ShouldReturnCorrectToken()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, new NetworkClient(), prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var authToken = await api.GetAuthorizationTokenAsync(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            authToken.Should().NotBeNull();
        }

        [Test]
        public async Task GetAuthorizationTokenAsync_CancellationTokenAlreadyCanceled_ShouldReturnNull()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, new NetworkClient(), prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var token = await api.GetAuthorizationTokenAsync(new CancellationToken(true));

            // Assert
            token.Should().BeNull();
        }

        [Test]
        public async Task GetAuthorizationTokenAsync_AndFirstTtyReturnError_ThenShouldRepeatRequestAndReturnToken()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            var networkClient = Substitute.For<INetworkClient>();
            networkClient.SendAsync(Arg.Any<string>(), Arg.Any<WebRequestMessage>(), Arg.Any<CancellationToken>())
                .Returns(UniTask.FromResult(new WebResponseMessage // Return error server response
                    {
                        ResponseCode = 503,
                        Result = UnityWebRequest.Result.ConnectionError,
                        Text = string.Empty
                    }),
                    UniTask.FromResult(new WebResponseMessage
                    {
                        ResponseCode = 200,
                        Result = UnityWebRequest.Result.Success,
                        Text = @"{""jsonrpc"": ""2.0"", ""result"": ""123456"", ""id"": ""1""}"
                    })
                );

            using var api = new ServerApi(StagingUrl, networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var authToken = await api.GetAuthorizationTokenAsync(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            authToken.Should().Be("123456");
        }

        [Test]
        public async Task GetAuthorizationTokenAsync_AndCurrentTokenWasExpired_ThenShouldRepeatRequestAndAfterGetRevokedTokenRepeatAgainAndReturnToken()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            prefs.AuthorizationToken.Value = "123456";
            prefs.AuthorizationTokenExpired.Value = true;
            var networkClient = Substitute.For<INetworkClient>();
            networkClient.SendAsync(Arg.Any<string>(), Arg.Any<WebRequestMessage>(), Arg.Any<CancellationToken>())
                .Returns(UniTask.FromResult(new WebResponseMessage // Return error server response
                    {
                        ResponseCode = 403,
                        Result = UnityWebRequest.Result.ProtocolError,
                        Text = @"{""jsonrpc"": ""2.0"", ""error"": {""code"": 5, ""message"": ""Revoked.""}, ""id"": ""1""}"
                    }),
                    UniTask.FromResult(new WebResponseMessage
                    {
                        ResponseCode = 200,
                        Result = UnityWebRequest.Result.Success,
                        Text = @"{""jsonrpc"": ""2.0"", ""result"": ""123456"", ""id"": ""1""}"
                    })
                );
            using var api = new ServerApi(StagingUrl, networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var authToken = await api.GetAuthorizationTokenAsync(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            authToken.Should().Be("123456");
        }

        [Test]
        public async Task RequestTokenAsync_ShouldReturnCorrectToken()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var requestResponse = await api.RequestNewToken(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            requestResponse.Result.Should().Be(UnityWebRequest.Result.Success);
            var token = JsonFacade.DeserializeObject<TokenResponse>(requestResponse.Text);
            token.Token.Should().NotBeNullOrEmpty();
        }

        [Test]
        public async Task WhenGetContextAsync_WithCorrectConfiguration_ThenShouldReturnNotEmptyContext()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var context = await api.GetContextAsync(_timeoutCts.Token);
            // Cache config for fast search in config
            File.WriteAllText(Path.Combine(Application.persistentDataPath, "context_test.json"), JsonFacade.SerializeObject(context));

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().NotBeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndCancellationTokenAlreadyCanceled_ThenShouldReturnNull()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var context = await api.GetContextAsync(new CancellationToken(true));

            // Assert
            context.Should().BeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndFirstTryReturnError_ThenShouldRepeatRequestAndReturnContext()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            prefs.AuthorizationToken.Value = "123456";
            var networkClient = Substitute.For<INetworkClient>();
            networkClient.SendAsync(Arg.Any<string>(), Arg.Any<WebRequestMessage>(), Arg.Any<CancellationToken>())
                .Returns(UniTask.FromResult(new WebResponseMessage // Return error server response
                    {
                        ResponseCode = 503,
                        Result = UnityWebRequest.Result.ConnectionError,
                        Text = string.Empty
                    }),
                    new Func<UniTask<WebResponseMessage>>(() => // Return context
                    {
                        var configAsset = Resources.Load<TextAsset>("Network/context_response");
                        return UniTask.FromResult(new WebResponseMessage
                        {
                            ResponseCode = 200,
                            Result = UnityWebRequest.Result.Success,
                            Text = configAsset.text
                        });
                    })());
            using var api = new ServerApi(StagingUrl, networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var context = await api.GetContextAsync(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().NotBeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndAuthTokenWasExpired_ThenShouldRequestNewTokenAndReturnContext()
        {
            // Arrange
            using var _ = new NoLogsIgnoreFailingMessagesScope();
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            prefs.AuthorizationToken.Value = "123456";
            var networkClient = Substitute.For<INetworkClient>();
            networkClient.SendAsync(Arg.Any<string>(), Arg.Any<WebRequestMessage>(), Arg.Any<CancellationToken>())
                .Returns(UniTask.FromResult(new WebResponseMessage // Return expired server answer
                    {
                        ResponseCode = 403,
                        Result = UnityWebRequest.Result.ProtocolError,
                        Text = @"{""jsonrpc"": ""2.0"", ""error"": {""code"": 3, ""message"": ""Expired.""}, ""id"": ""1""}"
                    }),
                    UniTask.FromResult(new WebResponseMessage // Return valid token server answer
                    {
                        ResponseCode = 200,
                        Result = UnityWebRequest.Result.Success,
                        Text = @"{""jsonrpc"": ""2.0"", ""result"": ""654321"", ""id"": ""1""}"
                    }),
                    new Func<UniTask<WebResponseMessage>>(() => // Return context
                    {
                        var configAsset = Resources.Load<TextAsset>("Network/context_response");
                        return UniTask.FromResult(new WebResponseMessage
                        {
                            ResponseCode = 200,
                            Result = UnityWebRequest.Result.Success,
                            Text = configAsset.text
                        });
                    })());
            using var api = new ServerApi(StagingUrl, networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var context = await api.GetContextAsync(_timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().NotBeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndCancelTokenOnTheNextFrame_ThenRequestShouldCancelled()
        {
            LogAssert.Expect(LogType.Error, new Regex("cancelled"));
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);
            using var cancellationToken = CancellationTokenSource.CreateLinkedTokenSource(_timeoutCts.Token);
            prefs.AuthorizationToken.Value = await api.GetAuthorizationTokenAsync(_timeoutCts.Token);

            // Act
            var contextTask = api.GetContextAsync(cancellationToken.Token);
            await Task.Yield();
            Debug.Log("Cancel contextTask");
            cancellationToken.Cancel();
            Debug.Log("Await contextTask");
            var context = await contextTask;

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().BeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndCancelTokenAfterMethodFinish_ThenNothingShouldHappen()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);
            using var cancellationToken = CancellationTokenSource.CreateLinkedTokenSource(_timeoutCts.Token);

            // Act
            var context = await api.GetContextAsync(cancellationToken.Token);
            cancellationToken.Cancel();

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().NotBeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndChangeServerUrlToNewOneBeforeGetContext_ThenRequestShouldBeCancelledAndReturnNull()
        {
            // Expect 2 cancelled operation, RequestToken and RequestContext
            LogAssert.Expect(LogType.Error, new Regex("cancelled"));
            LogAssert.Expect(LogType.Error, new Regex("cancelled"));

            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var contextTask = api.GetContextAsync(_timeoutCts.Token);
            api.ChangeServerUrl(ProductionUrl);
            var context = await contextTask;

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().BeNull();
        }

        [Test]
        public async Task WhenGetContextAsync_AndChangeServerUrlToSameUrlBeforeGetContext_ThenShouldReturnContextForCurrentUrl()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var contextTask = api.GetContextAsync(_timeoutCts.Token);
            api.ChangeServerUrl(StagingUrl);
            var context = await contextTask;

            // Assert
            FailIfTimeoutTokenWasCanceled();
            context.Should().NotBeNull();
        }

        [Test]
        public async Task WhenSendEvents_ThenShouldReturnSuccess()
        {
            // Arrange
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            using var api = new ServerApi(StagingUrl, _networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var events = new List<AppLaunchEvent> { new() };
            var isSendSuccess = await api.SendEvents(EventType.AppLaunch, events, _timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            isSendSuccess.Should().BeTrue();
        }

        [Test]
        public async Task WhenSendEvents_AndFirstTryFailedWithExpiredToken_ThenShouldRepeatRequestAndReturnTrue()
        {
            // Arrange
            using var _ = new NoLogsIgnoreFailingMessagesScope();
            using var prefs = await CreateGeneralPrefsAsync(_timeoutCts.Token);
            using var appStatePrefs = await CreateAppStatePrefsAsync(_timeoutCts.Token);
            prefs.AuthorizationToken.Value = "123456";
            var networkClient = Substitute.For<INetworkClient>();
            networkClient.SendAsync(Arg.Any<string>(), Arg.Any<WebRequestMessage>(), Arg.Any<CancellationToken>())
                .Returns(UniTask.FromResult(new WebResponseMessage // Return error server response
                    {
                        ResponseCode = 403,
                        Result = UnityWebRequest.Result.ProtocolError,
                        Text = @"{""jsonrpc"": ""2.0"", ""error"": {""code"": 3, ""message"": ""Expired.""}, ""id"": ""1""}"
                    }),
                    UniTask.FromResult(new WebResponseMessage // Return valid token server answer
                    {
                        ResponseCode = 200,
                        Result = UnityWebRequest.Result.Success,
                        Text = @"{""jsonrpc"": ""2.0"", ""result"": ""654321"", ""id"": ""1""}"
                    }),
                    UniTask.FromResult(new WebResponseMessage // Return success storeEvent response
                    {
                        ResponseCode = 200,
                        Result = UnityWebRequest.Result.Success,
                        Text = @"{""jsonrpc"": ""2.0"", ""result"": ""true"", ""id"": ""1""}"
                    })
                );
            using var api = new ServerApi(StagingUrl, networkClient, prefs, appStatePrefs, AuthConfig, _platformAPI);

            // Act
            var events = new List<AppLaunchEvent> { new() };
            var isSendSuccess = await api.SendEvents(EventType.AppLaunch, events, _timeoutCts.Token);

            // Assert
            FailIfTimeoutTokenWasCanceled();
            isSendSuccess.Should().BeTrue();
        }

        private async Task<AppStatePrefs> CreateAppStatePrefsAsync(CancellationToken cancellationToken)
        {
            AppStatePrefs result = default;
            while (result == null)
            {
                try
                {
                    result = AppStatePrefs.Create(EditorModeTestsEnvironment.GeneralPrefsPath);
                }
                catch (MagifyBinaryStorageLockedException)
                {
                    await Task.Delay(100, cancellationToken);
                }
            }
            return result;
        }

        private async Task<GeneralPrefs> CreateGeneralPrefsAsync(CancellationToken cancellationToken)
        {
            GeneralPrefs result = default;
            while (result == null)
            {
                try
                {
                    result = GeneralPrefs.Create(EditorModeTestsEnvironment.GeneralPrefsPath, EditorModeTestsEnvironment.LocalGeneralPrefsPath, _platformAPI);
                }
                catch (MagifyBinaryStorageLockedException)
                {
                    await Task.Delay(100, cancellationToken);
                }
            }
            return result;
        }

        private void FailIfTimeoutTokenWasCanceled()
        {
            if (_timeoutCts.IsCancellationRequested)
            {
                Assert.Fail("Timeout token was canceled");
            }
        }
    }
    */
}