using System;
using JetBrains.Annotations;

namespace Magify.Tests
{
    internal class NetworkTestEnvironment
    {
        private class AuthorizationConfigBuilder : IAuthorizationConfigBuilder
        {
            [NotNull]
            public AuthorizationConfig AuthorizationConfig { get; }

            public bool IsDisposed { get; private set; }

            public AuthorizationConfigBuilder(AuthorizationConfig authorizationConfig)
            {
                AuthorizationConfig = authorizationConfig;
            }

            public void Dispose()
            {
                IsDisposed = true;
            }
        }

        public static readonly IAuthorizationConfigBuilder AuthConfig = new AuthorizationConfigBuilder(new AuthorizationConfig
        {
            UserClientId = "6a0bba16-5905-4c3e-b21d-49db6467e0d8",
            IsNewUser = false,
            DeviceName = "phone-xhdpi",
            DeviceVersion = "30",

            ApplicationName = "example-android",
            ApplicationVersion = new AppVersionProvider().AppVersion,
            SupportedOrientation = Orientation.Portrait,

            SdkVersion = PackageInfo.Version,
            FirstLaunchDate = DateTime.Now,

            LanguageCode = "ru-RU",
            CountryCode = "RU",
        });
    }
}