using System;
using System.Threading.Tasks;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class Test
        {
            [Test]
            public async Task A()
            {
                // Arrange
                using var client = CreateDefaultAndInit();
                var contextRequests = 0;
                client.OnConfigSyncRequested += () => contextRequests++;
                // get PlatformDefault
                var platform = (PlatformDefault)GetPlatformAPI(client);
                GetSessionCounter(client).Interval.Value = TimeSpan.FromSeconds(100);

                // Act
                platform.GoToBackground();
                await Task.Delay(TimeSpan.FromSeconds(2));
                platform.ReturnToForeground();
                platform.TweakUserLocale("rr-RR");

                client.IsGdprGranted.Value = true;

                // Assert
                contextRequests.Should().Be(1);
            }
        }
    }
}