using System.Threading.Tasks;
using Cysharp.Threading.Tasks;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class InfinitiveLoops : MagifyClientTestsPart
        {
            [Test]
            [TestCase(1, ClientKind.Full)]
            [TestCase(1, ClientKind.Minimal)]
            [TestCase(30, ClientKind.Full)]
            [TestCase(30, ClientKind.Minimal)]
            [TestCase(100, ClientKind.Full)]
            [TestCase(100, ClientKind.Minimal)]
            public async Task WhenMagifyClientHotStarted_ThenSetup_ThenNoInfinitiveLoop(int delayMs, ClientKind kind)
            {
                // Arrange offline
                using (CreateDefaultAndInit(kind))
                {
                }

                // Arrange online
                var network = new NetworkMoq(async (_, m, ct) =>
                {
                    await UniTask.Delay(delayMs, cancellationToken: ct);
                    return NetworkMoq.OkResult(m);
                });
                using var magifyClient = CreateDefault(kind: kind, networkClient: network, environment: Environment.Staging);
                // Act
                magifyClient.InitializeSdk();
                magifyClient.Setup();

                await UniTask.Delay(delayMs + delayMs / 10, cancellationToken: GetCancellationToken());

                // Assert
                Assert.Pass();
            }

            [Test]
            [TestCase(true, 1, ClientKind.Full)]
            [TestCase(false, 1, ClientKind.Minimal)]
            [TestCase(true, 30, ClientKind.Full)]
            [TestCase(false, 30, ClientKind.Minimal)]
            [TestCase(true, 100, ClientKind.Full)]
            [TestCase(false, 100, ClientKind.Minimal)]
            public async Task WhenMagifyClientHotStarted_ThenSetStatusesAndSetup_ThenNoInfinitiveLoop(bool status, int delayMs, ClientKind kind)
            {
                // Arrange offline
                using (CreateDefaultAndInit(kind))
                {
                }

                // Arrange online
                var network = new NetworkMoq(async (_, m, ct) =>
                {
                    await UniTask.Delay(delayMs, cancellationToken: ct);
                    return NetworkMoq.OkResult(m);
                });
                using var magifyClient = CreateDefault(kind: kind, networkClient: network, environment: Environment.Staging);
                // Act
                magifyClient.InitializeSdk();
                magifyClient.SubscriptionStatus.Value = SubscriptionStatus.Paid;
                magifyClient.AuthorizationStatus.Value = AuthorizationStatus.Authorized;
                magifyClient.IsGdprGranted.Value = status;
                magifyClient.SetAttStatus(status);

                magifyClient.Setup();

                await UniTask.Delay(delayMs + delayMs / 10, cancellationToken: GetCancellationToken());

                // Assert
                Assert.Pass();
            }
        }
    }
}