using FluentAssertions;
using Magify.Model;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class AttStatus : MagifyClientTestsPart
        {
            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void WhenMagifyClientInit_AttStatusMustBeNull(ClientKind kind)
            {
                // Arrange
                // Act
                using var magifyClient = CreateDefaultAndInit(kind);

                // Assert
                magifyClient.AttAuthorizationStatus.Value.Should().BeNull();
            }

            [Test]
            [TestCase(true, ClientKind.Minimal)]
            [TestCase(true, ClientKind.Full)]
            [TestCase(false, ClientKind.Minimal)]
            [TestCase(false, ClientKind.Full)]
            public void WhenMagifyClientInit_AndSetAttStatus_AttStatusMustBeChanged(bool value, ClientKind kind)
            {
                // Arrange
                using var magifyClient = CreateDefaultAndInit(kind);

                // Act
                magifyClient.SetAttStatus(value);

                // Assert
                magifyClient.AttAuthorizationStatus.Value.Should().Be(value);
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void WhenMagifyClientInit_AuthTokenPayloadMustNotContainsIsIdfaAvailable(ClientKind kind)
            {
                // Arrange
                // Act
                using var magifyClient = CreateDefaultAndInit(kind: kind, editorDevice: EditorDevice.GetDefaultIOSDevice());

                // Assert
                var tokenPayload = (AuthTokenPayload)GetServerApi(magifyClient).CreateNewTokenRequestPayloadNonStatic().Payload;
                tokenPayload.IsIdfaAvailable.Should().Be(null);
            }

            [Test]
            [TestCase(true, ClientKind.Minimal)]
            [TestCase(true, ClientKind.Full)]
            [TestCase(false, ClientKind.Minimal)]
            [TestCase(false, ClientKind.Full)]
            public void WhenMagifyClientInit_AndSetAttStatus_AuthTokenPayloadMustContainsIsIdfaAvailable(bool value, ClientKind kind)
            {
                // Arrange
                using var magifyClient = CreateDefaultAndInit(kind: kind, editorDevice: EditorDevice.GetDefaultIOSDevice());

                // Act
                magifyClient.SetAttStatus(value);

                // Assert
                var tokenPayload = (AuthTokenPayload)GetServerApi(magifyClient).CreateNewTokenRequestPayloadNonStatic().Payload;
                tokenPayload.IsIdfaAvailable.Should().Be(value);
            }
        }
    }
}