﻿using System.Linq;
using Magify.Model;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class CampaignsExtensionsTests
    {
        private class FakeCampaign : ICampaign
        {
            public CampaignType Type { get; }
            public string Name { get; }

            public FakeCampaign(CampaignType type, string name = "fake_campaign_name")
            {
                Type = type;
                Name = name;
            }
        }

        [Test]
        public void IsRequiredProductTypeAllChecked()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();
            var productTypes = typeof(ProductType).GetEnumValues();
            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                foreach (var productType in productTypes)
                {
                    var result = campaignType.IsRequiredProductType((Magify.Model.ProductType)productType);
                    Assert.NotNull(result);
                }
            }
        }

        [Test]
        public void IsSupportNestedICampaignAllChecked()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();
            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                var result = new FakeCampaign(campaignType).IsSupportNested();
                Assert.NotNull(result);
            }
        }

        [Test]
        public void IsSupportNestedFromModelAllChecked()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();
            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                var result = campaignType.IsSupportNested();
                Assert.NotNull(result);
            }
        }

        [Test]
        public void IsSupportNestedAllChecked()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();
            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                var result = campaignType.IsSupportNested();
                Assert.NotNull(result);
            }
        }

        [Test]
        public void IsLimitedTimeOfferAllChecked()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();

            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                var result = campaignType.IsLimitedOffer();
                Assert.NotNull(result);
            }
        }
    }
}