using System;

namespace Magify
{
    internal static class TimeExtensions
    {
        public static TimeSpan? MaxOf(TimeSpan? first, TimeSpan? second)
        {
            if (first == null) return second;
            if (second == null) return first;

            return first.Value > second.Value ? first : second;
        }

        public static DateTime? MaxOf(DateTime? first, DateTime? second)
        {
            if (!first.HasValue) return second;
            if (!second.HasValue) return first;
            return first.Value > second.Value ? first : second;
        }

        public static DateTime MinOf(DateTime first, DateTime second)
        {
            return first < second ? first : second;
        }

        public static DateTime? MinOf(DateTime? first, DateTime? second)
        {
            if (!first.HasValue) return second;
            if (!second.HasValue) return first;
            return first.Value < second.Value ? first : second;
        }
    }
}