﻿using UnityEngine;

namespace Magify
{
    internal static class RectTransformExtensions
    {
        public static void SetLeft(this RectTransform rt, float left)
        {
            rt.offsetMin = new Vector2(left, rt.offsetMin.y);
        }

        public static void SetRight(this RectTransform rt, float right)
        {
            rt.offsetMax = new Vector2(-right, rt.offsetMax.y);
        }

        public static void SetTop(this RectTransform rt, float top)
        {
            rt.offsetMax = new Vector2(rt.offsetMax.x, -top);
        }

        public static void SetBottom(this RectTransform rt, float bottom)
        {
            rt.offsetMin = new Vector2(rt.offsetMin.x, bottom);
        }
        
        public static void SetHorizontalFillPercentage(this RectTransform rt, float fillPercentage)
        {
            var borderOffset = (1f - fillPercentage) / 2f; 
            
            rt.anchorMin = new Vector2(borderOffset, 0.05f); // hardcoded values 5% of margin from top
            rt.anchorMax = new Vector2(1 - borderOffset, 0.95f); // hardcoded values 5% of margin from bottom
            
            rt.sizeDelta = Vector2.zero;
        }
    }
}