using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    internal static class NumberExtensions
    {
        public static int? MaxOf(int? a, int? b)
        {
            return Nullable.Compare(a, b) > 0 ? a : b;
        }

        public static long? MaxOf(long? a, long? b)
        {
            return Nullable.Compare(a, b) > 0 ? a : b;
        }

        public static float? MaxOf(float? a, float? b)
        {
            return Nullable.Compare(a, b) > 0 ? a : b;
        }

        public static double? MaxOf(double? a, double? b)
        {
            return Nullable.Compare(a, b) > 0 ? a : b;
        }

        public static bool TryToInt32(object value, out int result)
        {
            try
            {
                result = Convert.ToInt32(value);
                return true;
            }
            catch
            {
                result = 0;
                return false;
            }
        }

        public static bool TryToInt64(object value, out long result)
        {
            try
            {
                result = Convert.ToInt64(value);
                return true;
            }
            catch
            {
                result = 0;
                return false;
            }
        }

        public static bool TryToSingle(object value, out float result)
        {
            try
            {
                result = Convert.ToSingle(value);
                return true;
            }
            catch (Exception)
            {
                result = 0;
                return false;
            }
        }

        [NotNull]
        public static IEnumerable<int> EnumerateEach(this int number)
        {
            for (var i = 0; i < number; i++)
            {
                yield return i;
            }
        }
    }
}