﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public static class LoggingScope
    {
        public const string Lto = "LTO";
        public const string Scheduler = "Scheduler";
        public const string Storage = "Storage";
        public const string Content = "Content";
        public const string Features = "Features";
        public const string Analytics = "Analytics";
        public const string Network = "Network";
        public const string Purchases = "Purchases";
        public const string Migration = "Migration";
        public const string Editor = "Editor";
        public const string AppState = "AppState";
        public const string Aghanim = "Aghanim";

        [NotNull]
        [ItemNotNull]
        public static IEnumerable<string> IterateScopes()
        {
            yield return Lto;
            yield return Scheduler;
            yield return Storage;
            yield return Content;
            yield return Features;
            yield return Analytics;
            yield return Network;
            yield return Purchases;
            yield return Migration;
            yield return AppState;
            yield return Aghanim;
#if UNITY_EDITOR
            yield return Editor;
#endif
        }
    }
}