using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    internal static class ListExtensions
    {
        [ContractAnnotation("item:null => null; item:notnull => notnull")]
        public static T AddTo<T, TItem>([CanBeNull] this T item, [NotNull] IList<TItem> list)
            where T: TItem
        {
            list.Add(item);
            return item;
        }
    }
}