﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public static class EnumerableExtensions
    {
        public static T[] ToArray<T>([NotNull] this IEnumerable<T> enumerable, int length)
        {
            var result = new T[length];
            var index = 0;
            foreach (var item in enumerable)
            {
                result[index] = item;
                index++;
            }
            return result;
        }
    }
}