using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify
{
    internal static class EnumExtensions
    {
        public static string ToEnumString<T>(this T type)
            where T : Enum
        {
            // TODO OPTIMIZATION REQUIRED
            var enumType = typeof(T);
            var name = Enum.GetName(enumType, type);
            var enumMemberAttribute = ((EnumMemberAttribute[])enumType.GetField(name).GetCustomAttributes(typeof(EnumMemberAttribute), true)).Single();
            return enumMemberAttribute.Value;
        }

        public static T ToEnumMember<T>(this string str)
            where T : Enum
        {
            return str.AsSpan().ToEnumMember<T>();
        }

        public static T ToEnumMember<T>(this ReadOnlySpan<char> str)
            where T : Enum
        {
            // TODO OPTIMIZATION REQUIRED
            var enumType = typeof(T);
            foreach (var name in Enum.GetNames(enumType))
            {
                var enumMemberAttribute = (enumType.GetField(name).GetCustomAttributes(typeof(EnumMemberAttribute), true) as EnumMemberAttribute[])?.FirstOrDefault();
                if (enumMemberAttribute != null && str.Equals(enumMemberAttribute.Value, StringComparison.Ordinal))
                {
                    return (T)Enum.Parse(enumType, name);
                }
            }
            //throw exception or whatever handling you want or
            return default;
        }

        [NotNull]
        public static IEnumerable<T> GetValues<T>()
        {
            // TODO OPTIMIZATION REQUIRED
            return Enum.GetValues(typeof(T)).Cast<T>();
        }

        [NotNull]
        public static IEnumerable<T> GetValues<T>(out int length)
        {
            // TODO OPTIMIZATION REQUIRED
            var values = Enum.GetValues(typeof(T));
            length = values.Length;
            return values.Cast<T>();
        }

        public static IEnumerable<Enum> GetUniqueFlags(this Enum flags)
        {
            ulong flag = 1;
            foreach (var value in Enum.GetValues(flags.GetType()).Cast<Enum>())
            {
                ulong bits = Convert.ToUInt64(value);
                while (flag < bits)
                {
                    flag <<= 1;
                }

                if (flag == bits && flags.HasFlag(value))
                {
                    yield return value;
                }
            }
        }
    }
}