using System.IO;
using System.Text.RegularExpressions;
using UnityEngine;

namespace Magify
{
    public static class EmbeddedCreativesUtilities
    {
        public static string RemovePostfixFromUrl(string value)
        {
            return Regex.Replace(value, @"_[A-Za-z0-9]+", "");
        }

        public static string GetStreamingAssetNameWithoutExtension(string url)
        {
            // url: "https://d2a0mqwvgrh7v5.cloudfront.net/media/images/uc-sample-gp/14eee9ce-50d4-481b-8afb-e30247b6701e_EQU23FR.png"
            var fileName = Path.GetFileNameWithoutExtension(url);

            // Need remove "_EQU23FR" suffix from file name "14eee9ce-50d4-481b-8afb-e30247b6701e_EQU23FR"
            // Lto "default_spot_main_lto_1" will not be affected
            var match = Regex.Match(fileName, "^[A-Za-z0-9-]+_[A-Za-z0-9]+$");
            if (match.Success)
            {
                fileName = RemovePostfixFromUrl(fileName);
            }

            // fileName: "14eee9ce-50d4-481b-8afb-e30247b6701e"
            return fileName;
        }

        internal static string GetAssetRelativePath(string absolutePath)
        {
            return Path.GetRelativePath(Path.GetDirectoryName(Application.dataPath), absolutePath);
        }

        internal static string GetPathToRootDefaultCreatives()
        {
            return Path.Combine(Application.streamingAssetsPath, PackageInfo.RootDefaultCreatives);
        }

        internal static string GetPathToAssetsJson()
        {
            return Path.Combine(Application.streamingAssetsPath, PackageInfo.DefaultCreativesConfig);
        }
    }
}