﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class UnexpectedUnderlyingEnumTypeException : MagifyException
    {
        public Type EnumType { get; }
        public Type UnderlyingType { get; }

        public UnexpectedUnderlyingEnumTypeException([NotNull] Type enumType, [NotNull] Type underlyingType)
            : base($"Unexpected underlying type of enum {enumType.FullName} - {underlyingType.FullName}")
        {
            EnumType = enumType;
            UnderlyingType = underlyingType;
        }
    }
}