﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class MagifyFailedToLoadBinaryStorageException : MagifyBinaryStorageException
    {
        public MagifyFailedToLoadBinaryStorageException([NotNull] string storage, bool isRetry, [NotNull] Exception innerException)
            : base($"Magify failed to load data from binary storage '{storage}' with exception ({nameof(isRetry)}: {isRetry}).", innerException)
        {
        }
    }
}