﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class DuplicateBinaryStorageSectionException : MagifyBinaryStorageException
    {
        public Type Type { get; }
        public string StorageFileName { get; }

        public DuplicateBinaryStorageSectionException([NotNull] Type type, string storageFileName)
            : base($"You're trying to add second section for type {type.FullName} to storage {storageFileName}. This is not allowed")
        {
            Type = type;
            StorageFileName = storageFileName;
        }
    }
}