using System;
using System.Threading;
using System.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify
{
    internal static class TaskHelper
    {
        [NotNull]
        internal static Task WaitUntil([NotNull] Func<bool> predicate, CancellationToken token)
        {
            if (token.IsCancellationRequested)
            {
                return Task.FromCanceled(token);
            }

            var promise = new TaskCompletionSource<object>();
            token.Register(cancel);
            _ = routine();
            return promise.Task!;

            void cancel() => promise.TrySetCanceled();
            async Task routine()
            {
                while (true)
                {
                    if (token.IsCancellationRequested)
                    {
                        promise.TrySetCanceled(token);
                        return;
                    }

                    if (predicate())
                    {
                        promise.SetResult(null);
                        return;
                    }

                    await Task.Yield();
                }
            }
        }

        [NotNull]
        internal static Task WaitWhile([NotNull] Func<bool> predicate, CancellationToken token)
        {
            if (token.IsCancellationRequested)
            {
                return Task.FromCanceled(token);
            }

            var promise = new TaskCompletionSource<object>();
            token.Register(cancel);
            _ = routine();
            return promise.Task!;

            void cancel() => promise.TrySetCanceled();
            async Task routine()
            {
                while (true)
                {
                    if (token.IsCancellationRequested)
                    {
                        promise.TrySetCanceled(token);
                        return;
                    }

                    if (predicate())
                    {
                        await Task.Yield();
                    }
                    else
                    {
                        promise.SetResult(null);
                        return;
                    }
                }
            }
        }
    }
}