using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    internal class PurchasesStorage
    {
        private const string PurchasesFolderName = "purchases";
        private const string PurchasesForVerificationFileName = "purchases_for_verification.json";
        private const string TrustedPurchasesFileName = "trusted_purchases.json";

        [NotNull]
        private readonly FileStorage _storage;
        public string RootFolderPath { get; }

        public PurchasesStorage(string storagePath)
        {
            _storage = new FileStorage(storagePath, PurchasesFolderName);
            RootFolderPath = storagePath;
        }

        [NotNull]
        public List<PurchaseRecord> LoadPurchaseRecords()
        {
            return _storage.LoadJson<List<PurchaseRecord>>(PurchasesForVerificationFileName)
                ?? new List<PurchaseRecord>();
        }

        public void SavePurchaseRecords([NotNull] IReadOnlyCollection<PurchaseRecord> unsentRecords)
        {
            var data = JsonFacade.SerializeObject(unsentRecords);
            _storage.Save(PurchasesForVerificationFileName, data);
        }

        [NotNull]
        public List<TrustedPurchaseRecord> LoadTrustedPurchaseRecords()
        {
            return _storage.LoadJson<List<TrustedPurchaseRecord>>(TrustedPurchasesFileName)
                ?? new List<TrustedPurchaseRecord>();
        }

        public void SaveTrustedPurchaseRecords([NotNull] IReadOnlyCollection<TrustedPurchaseRecord> unsentRecords)
        {
            var data = JsonFacade.SerializeObject(unsentRecords);
            _storage.Save(TrustedPurchasesFileName, data);
        }

        public bool PurchasesAreExist()
        {
            return _storage.Exists(PurchasesForVerificationFileName);
        }

        public bool TrustedPurchasesAreExist()
        {
            return _storage.Exists(TrustedPurchasesFileName);
        }
    }
}