﻿namespace Magify
{
    internal class EmbeddedPurchaseVerificationHandler : IPurchaseVerificationHandler
    {
        public RepeatState? HandlePurchaseVerification(PurchaseVerificationResult result)
        {
            return result.Code switch
            {
                PurchaseVerificationResultCode.Success
                or PurchaseVerificationResultCode.Invalid
                or PurchaseVerificationResultCode.InvalidGoogleCredentials
                    => RepeatState.Finish,
                PurchaseVerificationResultCode.Cancelled
                    => RepeatState.Retry,
                PurchaseVerificationResultCode.Fail
                or PurchaseVerificationResultCode.DoesntSupport
                or _
                    => RepeatState.Wait,
            };
        }
    }
}