#if UNITY_EDITOR || UNITY_IOS

using System;
using System.Runtime.InteropServices;

namespace Magify
{
    internal delegate void OnCloudStoreValueFetchedCallback(string key, string value);
    internal partial class PlatformIOS
    {
        [DllImport("__Internal")]
        private static extern void _magifyInitialize();

        [DllImport("__Internal")]
        private static extern string _magifyGetDeviceModel();

        [DllImport("__Internal")]
        private static extern string _magifyGetOsVersion();

        [DllImport("__Internal")]
        private static extern string _magifyGetBuildNumber();

        [DllImport("__Internal")]
        private static extern string _magifyGetLanguageWithRegion();

        [DllImport("__Internal")]
        private static extern string _magifyGetIdfa();

        [DllImport("__Internal")]
        private static extern string _magifyGetIdfv();

        [DllImport("__Internal")]
        private static extern string _magifyGetEncodedDeviceIdentifier();

        [DllImport("__Internal")]
        private static extern string _magifyGetStoreCountry();

        [DllImport("__Internal")]
        private static extern bool _magifyIsApplicationInstalled(string url);

        [DllImport("__Internal")]
        private static extern bool _magifySetOnApplicationEnterBackground(Action callback);

        [DllImport("__Internal")]
        private static extern bool _magifySetOnApplicationEnterForeground(Action callback);

        [DllImport("__Internal")]
        private static extern void _magifySetOnApplicationDidBecomeActive(Action onApplicationDidBecomeActive);

        [DllImport("__Internal")]
        private static extern void _magifySetOnApplicationWillResignActive(Action onApplicationWillResignActive);

        [DllImport("__Internal")]
        private static extern bool _magifyDispose();

        [DllImport("__Internal")]
        private static extern string _magifyCollectMigrationData();

        [DllImport("__Internal")]
        private static extern void _magifyClearDataAfterMigration();

        [DllImport("__Internal")]
        private static extern string _magifyGetStringValueInKeychain(string key);

        [DllImport("__Internal")]
        private static extern void _magifySetStringValueInKeychain(string value, string key);

        [DllImport("__Internal")]
        private static extern void _magifyRemoveValueInKeychain(string key);

        [DllImport("__Internal")]
        private static extern void _magifyClearKeychains();

        [DllImport("__Internal")]
        private static extern void _magifySetOnCloudStoreValueFetched(OnCloudStoreValueFetchedCallback callback);

        [DllImport("__Internal")]
        private static extern void _magifyFetchValueFromCloudStore(string key);

        [DllImport("__Internal")]
        private static extern void _magifySetValueToCloudStore(string value, string key);

        [DllImport("__Internal")]
        private static extern void _magifyRemoveValueFromCloudStore(string key);
    }
}
#endif