using System.Collections.Generic;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal struct WebRequestMessage
    {
        [NotNull]
        public string Method { get; set; }
        public object Payload { get; set; }
        public string AuthToken { get; set; }
        public IReadOnlyCollection<string> ExpectedHeaders { get; init; }

        public override readonly string ToString()
        {
            return $"Method: {Method}\n" +
                   $"PayloadParams: {Payload}\n" +
                   $"AuthToken: {AuthToken?[..Mathf.Clamp(AuthToken.Length, 0, 100)]}\n";
        }
    }
}