using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine.Networking;

namespace Magify
{
    internal class SyncUnityWebRequestBuilder : IUnityWebRequestBuilder
    {
        [ItemNotNull]
        public UniTask<UnityWebRequest> Post(
            [NotNull] string url,
            [NotNull] byte[] uploadBytes,
            CancellationToken _,
            int timeout)
        {
            return UniTask.FromResult(new UnityWebRequest(url, UnityWebRequest.kHttpVerbPOST)
            {
                uploadHandler = new UploadHandlerRaw(uploadBytes),
                downloadHandler = new DownloadHandlerBuffer(),
                timeout = timeout,
            });
        }
    }
}