using JetBrains.Annotations;

namespace Magify
{
    internal readonly struct MediaSource
    {
        [CanBeNull]
        public readonly string NetworkName;
        [CanBeNull]
        public readonly string CampaignName;
        [CanBeNull]
        public readonly string GroupName;

        public MediaSource(string networkName, string campaignName, string groupName)
        {
            NetworkName = networkName;
            CampaignName = campaignName;
            GroupName = groupName;
        }

        public override bool Equals(object obj)
        {
            return obj is MediaSource other && (NetworkName, CampaignName, GroupName).Equals((other.NetworkName, other.CampaignName, other.GroupName));
        }

        public override int GetHashCode()
        {
            return (NetworkName, CampaignName, GroupName).GetHashCode();
        }
    }
}