﻿using Newtonsoft.Json;

namespace Magify.Model
{
    internal class LocaleData
    {
        /// <example>en-US</example>
        [JsonProperty("languageWithRegion")]
        public string LanguageWithRegion { get; set; } = "en-US";

        /// <example>US</example>
        [JsonProperty("countryCode")]
        public string CountryCode { get; set; } = "US";

        public LocaleData()
        {
        }

        public LocaleData(string languageWithRegion)
        {
            LanguageWithRegion = languageWithRegion;
            CountryCode = languageWithRegion[(languageWithRegion.LastIndexOf('-')+1)..];
        }

        public LocaleData(string countryCode, string languageWithRegion)
        {
            CountryCode = countryCode;
            LanguageWithRegion = languageWithRegion;
        }

        public override string ToString()
        {
            return JsonFacade.SerializeObject(this);
        }
    }
}