using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class ContextPayload
    {
        [JsonProperty("denied_testing_campaign_types")]
        public ISet<string> DisabledCampaignTypes { get; set; }

        [JsonProperty("media_source", NullValueHandling = NullValueHandling.Ignore)]
        public string NetworkName { get; set; }

        [JsonProperty("acquisition_campaign_name", NullValueHandling = NullValueHandling.Ignore)]
        public string CampaignName { get; set; }

        [JsonProperty("acquisition_ad_group_name", NullValueHandling = NullValueHandling.Ignore)]
        public string GroupName { get; set; }

        [JsonProperty("scopes", NullValueHandling = NullValueHandling.Ignore), CanBeNull]
        public string[] Scopes { get; set; }

        public override string ToString()
        {
            return $"{nameof(DisabledCampaignTypes)}: {string.Join(", ", DisabledCampaignTypes)}\n" +
                   $"{nameof(NetworkName)}: {NetworkName},\n" +
                   $"{nameof(CampaignName)}: {CampaignName},\n" +
                   $"{nameof(GroupName)}: {GroupName}\n" +
                   $"{nameof(Scopes)}: {(Scopes == null ? "null" : string.Join(", ", Scopes))}\n";
        }
    }
}