using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class TemporaryLimitsGroup
    {
        [JsonProperty("id")]
        public long GroupId { get; set; }

        [JsonProperty("period")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        public TimeSpan PeriodOfLimits { get; set; }

        [JsonProperty("include_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAnyPurchased { get; set; }

        [JsonProperty("global_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? GlobalInterval { get; set; }

        [JsonProperty("interstitial_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? InterstitialInterval { get; set; }

        [JsonProperty("rv_interstitial_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? RewardedInterstitialInterval { get; set; }

        [JsonProperty("interstitials_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit InterstitialLimits { get; set; }

        [JsonProperty("inapps_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit InAppLimits { get; set; }

        [JsonProperty("lto_inapps_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit LtoInAppLimits { get; set; }

        [JsonProperty("subscriptions_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit SubscriptionLimits { get; set; }

        [JsonProperty("lto_subscriptions_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit LtoSubscriptionLimits { get; set; }

        [JsonProperty("cross_promos_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit CrossPromoLimits { get; set; }

        [JsonProperty("lto_cross_promos_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit LtoCrossPromoLimits { get; set; }

        [JsonProperty("notifications_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit NotificationLimits { get; set; }

        [JsonProperty("externals_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit ExternalLimits { get; set; }

        [JsonProperty("lto_externals_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit LtoExternalLimits { get; set; }

        [JsonProperty("rate_and_reviews_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit RateReviewLimits { get; set; }

        [JsonProperty("bonus_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit BonusLimits { get; set; }

        [JsonProperty("lto_bonus_limits")]
        [CanBeNull]
        public ImpressionPeriodLimit LtoBonusLimits { get; set; }
    }
}